/******************************************************************************************************
 **                                                                                                  **
 **                     Ex. Read Secound from RTC DS3231 to PCF8574 I/O 8 bit                        **
 **                                                                                                  ** 
 ******************************************************************************************************
 **                                                                                                  **
 **  Target MCU         : Mega 1280                                                                 ** 
 **                                                                                                  **
 **  Editor/Compiler    : Arduino 1.8.5                                                              **
 **                                                                                                  **                   
 **   Port Interface    :    Mega1280 Pin                           Device Interface                 **
 **                         --------------                     ---------------------                 **
 **                                                                                                  **
 **  I2C LCD            :   Pin D21(SCL)                                  SCL_LCD                    **                                                                                                  
 **                         Pin D20(SDA)                                  SDA-LCD                    **
 **                         I2C PCF8574 Address = 0x20(010 0 A2 A1 A0 )                              **
 **                                                                                                  **                         
 **                                                                                                  **
 **   I2C RTC DS3231    :   Pin D21(SCL)                                  SCL-RTC-DS3231             **                                                                                                             
 **                         Pin D20(SDA)                                  SDA-RTC-DS3231             **   
 **                         I2C DS3231 Address = 0x68 (110 1000)                                     **
 **                                                                                                  **
 **                                                                                                  **
 **                                                                                                  **
 ******************************************************************************************************/


#include <Wire.h>                //for LCD

#include <DS3231_CLOCK.h>

byte Eyear,Emonth,Edate,Eday,THyear         ; //keep value real Current for Date
byte Ehour,Eminute,Esecond                  ; //keep value real Current for Time
byte Ahour,Aminute                          ; //keep value real Current for Alarm Time

#define PCF8574   0x20                        //PCF8574=0x20  by A0,A1,A2=0

DS3231 Clock            ;

//----------Sub-Program ---------------

void Wr_PCF8574(byte address, byte db) 
{
 Wire.beginTransmission(address);
 Wire.write(db); //7-seg 8bit High colum Left
 Wire.endTransmission(); 
}

 
//#########################################################################
//##                          SETUP LOOP                                 ##
//#########################################################################

void setup() 
{ 
  
  Wire.begin()              ;  // Start the I2C interface  PCF8574
  delay(50)                 ; 
}



//######################################################################
//##                              MAIN LOOP                           ##
//######################################################################

void loop() 
{

 float tempC    = 0 ;
 float humidity = 0 ;
 char ssH,ssL ;

 //---------Read values Temp&Humidity  from the sensor -----------
 
//  tempC = SHT31.readTemperature();
//  humidity = SHT31.readHumidity();

 while(1)
 {

   Clock.getTime(Eyear,Emonth,Edate,Eday,Ehour,Eminute,Esecond) ;  //Read RTC Time+Date

   Wr_PCF8574(PCF8574,~Esecond)   ;
  
    delay(100)                                                  ;    

 }
 
}//end main



 

